<!DOCTYPE html>
<html>
<head>
	<title>Product Purchase Status</title>
	<style>
		/* Style the form */
		form {
			margin: 20px auto;
			padding: 20px;
			max-width: 400px;
			background-color: #f2f2f2;
			border-radius: 5px;
			box-shadow: 0 0 10px #ccc;
		}

		/* Style the input fields */
		input[type=text] {
			width: 100%;
			padding: 12px 20px;
			margin: 8px 0;
			display: inline-block;
			border: 1px solid #ccc;
			border-radius: 4px;
			box-sizing: border-box;
		}

		/* Style the button */
		button {
			background-color: #4CAF50;
			color: white;
			padding: 14px 20px;
			margin: 8px 0;
			border: none;
			border-radius: 4px;
			cursor: pointer;
		}

		/* Style the success message */
		.success {
			color: green;
			font-weight: bold;
		}

		/* Style the error message */
		.error {
			color: red;
			font-weight: bold;
		}
	</style>
</head>
<body>
	<form method="post" action="">
		<label for="product_id">Product ID:</label><br>
		<input type="text" id="product_id" name="product_id" required><br>
		<label for="token">Token:</label><br>
		<input type="text" id="token" name="token" required><br>
		<button type="submit">Check Status</button>
	</form>

	<?php
	if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		require_once 'vendor/autoload.php';

		$client = new Google_Client();
		$client->setApplicationName('StartMine: Mining & Rewards');
		$client->setAuthConfig('startmine-385205-4936b4968862.json');
		$client->addScope('https://www.googleapis.com/auth/androidpublisher');

		// Create a new instance of the Android Publisher service
		$service = new Google_Service_AndroidPublisher($client);

		// Get the product ID and token from the form submission
		$packageName = 'com.startmine.app';
		$productId = $_POST['product_id'];
		$purchaseToken = $_POST['token'];

		// Call the get method to retrieve the purchase details
		$productPurchaseService = $service->purchases_products;
		$productPurchase = $productPurchaseService->get($packageName, $productId, $purchaseToken);

		// Check if the purchase has been acknowledged
		if ($productPurchase->acknowledgementState == 1) {
			echo '<p class="success">Purchase has been acknowledged.</p>';
		}  else {
		// Acknowledge the purchase
		$acknowledgeRequest = new Google_Service_AndroidPublisher_ProductPurchasesAcknowledgeRequest();
		try {
			$res = $service->purchases_products->acknowledge($packageName, $productId, $purchaseToken, $acknowledgeRequest);

			// Display the acknowledge response
			echo '<p class="success">Purchase has been acknowledged.</p>';
			echo '<pre>' . print_r($res, true) . '</pre>';
		} catch (Google_Service_Exception $e) {
			// Print the error message if the acknowledge request is not successful
			echo '<p class="error">An error occurred while acknowledging the purchase:</p>';
			echo '<pre>' . print_r(json_decode($e->getMessage()), true) . '</pre>';
		}
	}
	}
	?>
</body>
</html>
