<!DOCTYPE html>
<html>
<head>
	<title>Google Play In-App Purchase Acknowledgement</title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</head>
<body>

<div class="container mt-5">
	<h1>Google Play In-App Purchase Acknowledgement</h1>
	<p>Click the "Acknowledge" button to acknowledge an in-app purchase:</p>
	<table class="table table-bordered">
		<thead>
			<tr>
				<th>Purchase Token</th>
				<th>Product ID</th>
				<th>Purchase Time</th>
				<th>State</th>
				<th>Actions</th>
			</tr>
		</thead>
		<tbody>
			<?php
 
require_once 'vendor/autoload.php';

// Replace with your OAuth 2.0 client ID
$client_id = 'client_secret_295013257939-khsg6913oluhklecgeagi783pckc1a3d.apps.googleusercontent.com.json';

// Replace with the path to your authentication credentials file
$credentials_file = 'startmine-385205-4936b4968862.json';

// Replace with the package name of your app
$package_name = 'com.startmine.app';

// Replace with the product IDs of the in-app purchases
$product_ids = ['zee.35', 'zee.60', 'zee.100'];

// Replace with the user's Google Play Store account ID
$account_id = 'zeeshanarif705@gmail.com';

// Replace with the path to your private key file
$private_key_file = 'startmine-385205-019aaea0ba30.p12';

// Replace with the password of your private key file
$private_key_password = 'notasecret';

// Authenticate your application
$client = new Google_Client();
$client->setClientId($client_id);
$client->setAuthConfig($credentials_file);
$client->addScope(Google_Service_AndroidPublisher::ANDROIDPUBLISHER);
$service = new Google_Service_AndroidPublisher_ProductPurchase($client);
$token = $client->fetchAccessTokenWithAssertion()['access_token'];
echo $token;
// List all purchases for the user
echo '<table>';
echo '<tr><th>Purchase Token</th><th>State</th><th>Time of Purchase</th><th>Actions</th></tr>';
//$results = $service->inappproducts->listInappproducts('com.startmine.app', $token);

foreach ($product_ids as $product_id) {
   $response = $service->purchases_products->get($package_name, $product_id, $account_id);
 
    foreach ($response->getPurchases() as $purchase) {
        echo '<tr>';
        echo '<td>' . $purchase->getPurchaseToken() . '</td>';
        echo '<td>' . $purchase->getPurchaseState() . '</td>';
        echo '<td>' . $purchase->getPurchaseTimeMillis() . '</td>';
        echo '<td>';
        if ($purchase->getPurchaseState() == 0) {
            echo '<button class="acknowledge-btn" data-purchase-token="' . $purchase->getPurchaseToken() . '">Acknowledge</button>';
        }
        echo '</td>';
        echo '</tr>';
    }
}
echo '</table>';
?>

<script>
$(document).ready(function() {
    // Handle the click event of the "Acknowledge" button
    $('.acknowledge-btn').click(function() {
        var purchase_token = $(this).data('purchase-token');
        $.post('acknowledge.php', {purchase_token: purchase_token}, function(response) {
            alert(response);
            location.reload();
        });
    });
});
</script>

</div>
</body>
</html>
